#ifndef __MT_MENU_BAR_H__
#define __MT_MENU_BAR_H__

#include <vector>

enum
{
	kAppleMenu = 128,
	kFileMenu,
	kEditMenu,
	kResourceMenu,
	kWindowsMenu
};

enum
{
	kAppleAboutItem = 1,
	
	kFileOpenItem = 1,
	kFileCloseItem,
	kFileCloseAllItem,
	kFileDivider1Item,
	kFileGetInfoItem,
	kFileImportItem,
	kFileExportItem,
	kFileDivider2Item,
	kFileApplyCMPOPatchItem,
	kFileRemoveCMPOPatchItem,
	kFileCreateCMPOPatchItem,
	kFileDivider3Item,
	kFileQuitItem,
	
	kEditUndoItem = 1,
	kEditDivider1Item,
	kEditCutItem,
	kEditCopyItem,
	kEditPasteItem,
	kEditClearItem,
	kEditDivider2Item,
	kEditSelectAllItem,
	kEditDivider3Item,
	kEditPreferencesItem,
	
	kResourceOpenByIDItem = 1,
	kResourceDivider1Item,
	kResourceAppendItem,
	kResourceEditItem,
	kResourceDivider2Item,
	kResourceTextDumpItem
};

struct MTMenuEntry
{
	SInt16		id;
	MenuHandle	menu;
};

class MTMenuBar
{
	public:
				MTMenuBar();
				~MTMenuBar();
		
		void		InstallMBAR(SInt16 id);
		
		MenuHandle	MyGetMenuHandle(SInt16 id);
		
		void		EnableItem(SInt16 menuID, SInt16 itemID);
		void		DisableItem(SInt16 menuID, SInt16 itemID);
		
		void		CheckItem(SInt16 menuID, SInt16 itemID, char markType = checkMark);
		void		UncheckItem(SInt16 menuID, SInt16 itemID);
		
		void		EnableMenu(SInt16 menuID);
		void		DisableMenu(SInt16 menuID);
		
		void		UpdateMenuBar(void);
	
	private:
		std::vector <MTMenuEntry>	menuList;
};

extern MTMenuBar	* gTheMenuBar;

#endif /* __MT_MENU_BAR_H__ */